<manual>
<identity>
## 工具名称
@tool://mermaid-viewer

## 简介
将Mermaid图表代码渲染成可视化图形，支持单图和多图画布两种展示模式

## 版本
1.2.0
</identity>

<purpose>
⚠️ **AI重要提醒**: 调用此工具前必须完整阅读本说明书，理解工具功能边界、参数要求和使用限制。禁止在不了解工具功能的情况下盲目调用。

## 核心问题定义
解决命令行环境中Mermaid图表难以直观查看的问题，让AI和用户能够快速可视化复杂的流程图、架构图、时序图等。

## 价值主张
- 🎯 **解决什么痛点**：命令行中的Mermaid纯文本难以理解，需要复制到在线编辑器才能查看
- 🚀 **带来什么价值**：一键可视化，即时查看图表，不打断工作流程
- 🌟 **独特优势**：
  - 无需服务器，自包含HTML
  - 支持单图和多图画布两种模式
  - 自动处理特殊字符（如@符号、路径等）
  - 简洁的垂直布局，所有图表一目了然

## 应用边界
- ✅ **适用场景**：
  - 展示系统架构图
  - 可视化工作流程
  - 显示时序图和状态图
  - 展示思维导图
  - 多个相关图表的对比查看（画布模式）
  - AI生成的复杂图表展示
  
- ❌ **不适用场景**：
  - 需要实时编辑图表
  - 需要导出为图片格式
  - 复杂的图表样式定制
  - 需要版本管理的图表
</purpose>

<usage>
## 使用时机
- AI生成Mermaid图表后需要展示给用户
- 用户提供Mermaid代码需要可视化验证
- 讨论系统架构时需要图形化展示
- 解释复杂流程时需要直观呈现
- 需要同时展示多个相关图表进行对比

## 工作模式
### 单图模式
适用于展示单个独立的图表，使用`mermaidCode`参数

### 画布模式  
适用于展示多个相关图表，使用`canvasId`或`charts`参数
- 所有图表垂直排列，清晰展示
- 每个图表都有独立的标题和描述
- 自动生成的文件名使用canvasId

## 操作步骤
### 单图模式
1. **准备阶段**：准备Mermaid图表代码
2. **执行阶段**：调用工具，传入mermaidCode、title、description
3. **验证阶段**：浏览器自动打开，展示渲染后的图表

### 画布模式
1. **准备阶段**：准备多个图表的代码和信息
2. **执行阶段**：调用工具，传入charts数组和canvasId
3. **验证阶段**：浏览器打开，垂直展示所有图表

## 最佳实践
- 🎯 **效率提升**：使用画布模式批量展示相关图表
- ⚠️ **避免陷阱**：确保Mermaid语法正确，工具会自动处理特殊字符
- 🔧 **故障排除**：如果图表不显示，检查浏览器控制台的错误信息
- 💡 **命名规范**：使用有意义的canvasId作为文件名，便于管理

## 注意事项
- 生成的HTML文件存储在~/.promptx/temp目录
- 需要网络连接以加载Mermaid.js库（使用CDN）
- 每次调用会打开新的浏览器标签页/窗口
- 工具会自动处理@符号等特殊字符，无需手动转义
</usage>

<parameter>
## 单图模式参数
| 参数名 | 类型 | 描述 | 示例 |
|--------|------|------|------|
| mermaidCode | string | Mermaid图表代码 | "graph TD\n A-->B" |
| title | string | 图表标题 | "系统架构图" |
| description | string | 图表描述 | "展示核心组件关系" |
| theme | string | 主题(default/dark/forest/neutral) | "default" |

## 画布模式参数
| 参数名 | 类型 | 描述 | 示例 |
|--------|------|------|------|
| canvasId | string | 画布ID，作为文件名 | "project-architecture" |
| charts | array | 图表数组 | 见下方示例 |
| title | string | 画布标题 | "项目架构设计" |
| description | string | 画布描述 | "包含系统各层架构图" |
| theme | string | 统一主题 | "default" |

### charts数组元素结构
```json
{
  "title": "图表标题",
  "description": "图表描述",
  "mermaidCode": "graph TD\n A-->B"
}
```

## 参数约束
- **mermaidCode长度**：不超过 50000 字符
- **title长度**：不超过 100 字符
- **description长度**：不超过 500 字符
- **theme**：必须是支持的主题之一
- **模式互斥**：不能同时使用单图和画布模式参数

## 参数示例
### 单图模式
```json
{
  "title": "系统架构图",
  "description": "展示微服务架构的组件关系",
  "mermaidCode": "graph TD\n    A[客户端] --> B[API网关]\n    B --> C[用户服务]\n    B --> D[订单服务]",
  "theme": "default"
}
```

### 画布模式
```json
{
  "canvasId": "system-design",
  "title": "系统设计文档",
  "description": "包含架构、流程和部署图",
  "charts": [
    {
      "title": "系统架构",
      "description": "整体架构设计",
      "mermaidCode": "graph TD\n A-->B"
    },
    {
      "title": "数据流程",
      "description": "数据处理流程",
      "mermaidCode": "flowchart LR\n Start-->End"
    }
  ],
  "theme": "default"
}
```
</parameter>

<outcome>
## 成功返回格式
### 单图模式
```json
{
  "success": true,
  "data": {
    "mode": "single",
    "filePath": "/Users/xxx/.promptx/temp/mermaid_1234567890.html",
    "opened": true,
    "timestamp": "2024-01-01T12:00:00.000Z",
    "message": "图表已生成并在浏览器中打开: mermaid_1234567890.html"
  }
}
```

### 画布模式
```json
{
  "success": true,
  "data": {
    "mode": "canvas",
    "canvasId": "system-design",
    "totalCharts": 3,
    "filePath": "/Users/xxx/.promptx/temp/system-design.html",
    "opened": true,
    "timestamp": "2024-01-01T12:00:00.000Z",
    "message": "画布已生成（包含3个图表）: system-design.html"
  }
}
```

## 错误处理格式
```json
{
  "success": false,
  "error": {
    "code": "VALIDATION_ERROR",
    "message": "参数验证失败: 必须提供mermaidCode或charts",
    "details": "错误详情"
  }
}
```

## 常见错误代码
- **VALIDATION_ERROR**：参数验证失败
- **EXECUTION_ERROR**：执行过程出错
- **BROWSER_OPEN_FAILED**：无法打开浏览器

## 结果解读指南
- **如何判断执行成功**：检查 success 字段为 true
- **如何获取文件路径**：data.filePath 包含生成的HTML文件路径
- **如何确认模式**：data.mode 显示是single还是canvas
- **如何处理错误**：根据 error.code 判断错误类型并处理

## 后续动作建议
- 成功时：等待浏览器加载，查看渲染后的图表
- 失败时：检查Mermaid语法，确认参数格式正确
- 画布模式：可以通过canvasId管理和查找生成的文件
- 如需保存：可在浏览器中另存为HTML或打印为PDF
</outcome>
</manual>